<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserAddress extends Model 
{

    protected $table = 'user_adress';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'addr', 'street', 'state', 'city', 'country', 'zipcode', 'latitude', 'longitude', 'remark', 'is_default');
    protected $visible = array('user_id', 'addr', 'street', 'state', 'city', 'country', 'zipcode', 'latitude', 'longitude', 'remark', 'is_default');

    public function users()
    {
        return $this->belongsTo('User', 'user_id');
    }

}